/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.config;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.config.SentinelConfigLoader;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public final class SentinelConfig {
    public static final int APP_TYPE_COMMON = 0;
    private static final Map<String, String> props = new ConcurrentHashMap<String, String>();
    private static int appType = 0;
    private static String appName = "";
    public static final String PROJECT_NAME_PROP_KEY = "project.name";
    public static final String APP_NAME_PROP_KEY = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.app.name";
    public static final String APP_TYPE_PROP_KEY = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.app.type";
    public static final String CHARSET = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.charset";
    public static final String SINGLE_METRIC_FILE_SIZE = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.metric.file.single.size";
    public static final String TOTAL_METRIC_FILE_COUNT = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.metric.file.total.count";
    public static final String COLD_FACTOR = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.flow.cold.factor";
    public static final String STATISTIC_MAX_RT = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.statistic.max.rt";
    public static final String SPI_CLASSLOADER = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.spi.classloader";
    public static final String MAX_RESOURCE_COUNT_PROPERTY_KEY = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.resource.amount.limit";
    public static final String MAX_CONTEXT_COUNT_PROPERTY_KEY = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.context.amount.limit";
    public static final String MAX_ORIGIN_COUNT_PROPERTY_KEY = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.statistic.origin.amount.limit";
    public static final String METRIC_LOG_FLUSH_INTERVAL_PROPERTY_KEY = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.metric.flush.interval";
    public static final String STAT_SLIDING_WINDOW_SAMPLE_COUNT_PROP_KEY = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.stat.slidingWindow.sampleCount";
    public static final String STAT_SLIDING_WINDOW_INTERVAL_MS_PROP_KEY = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.stat.slidingWindow.statIntervalMs";
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final long DEFAULT_SINGLE_METRIC_FILE_SIZE = 0x3200000L;
    public static final int DEFAULT_TOTAL_METRIC_FILE_COUNT = 6;
    public static final int DEFAULT_METRIC_LOG_FLUSH_INTERVAL = 1;
    public static final int DEFAULT_METRIC_LOG_FLUSH_QUEUE_SIZE = 60;
    public static final int DEFAULT_COLD_FACTOR = 3;
    public static final int DEFAULT_STATISTIC_MAX_RT = 60000;
    public static final int DEFAULT_SLIDING_WINDOW_STAT_INTERVAL_MS = 1000;
    public static final int DEFAULT_SLIDING_WINDOW_SAMPLE_COUNT = 2;

    private static void resolveAppType() {
        try {
            String type = SentinelConfig.getConfig(APP_TYPE_PROP_KEY);
            if (type == null) {
                appType = 0;
                return;
            }
            appType = Integer.parseInt(type);
            if (appType < 0) {
                appType = 0;
            }
        }
        catch (Exception ex) {
            appType = 0;
        }
    }

    private static void initialize() {
        SentinelConfig.setConfig(CHARSET, DEFAULT_CHARSET);
        SentinelConfig.setConfig(SINGLE_METRIC_FILE_SIZE, String.valueOf(0x3200000L));
        SentinelConfig.setConfig(TOTAL_METRIC_FILE_COUNT, String.valueOf(6));
        SentinelConfig.setConfig(COLD_FACTOR, String.valueOf(3));
        SentinelConfig.setConfig(STATISTIC_MAX_RT, String.valueOf(60000));
        SentinelConfig.setConfig(METRIC_LOG_FLUSH_INTERVAL_PROPERTY_KEY, String.valueOf(1));
        SentinelConfig.setConfig(MAX_RESOURCE_COUNT_PROPERTY_KEY, String.valueOf(6000));
        SentinelConfig.setConfig(MAX_CONTEXT_COUNT_PROPERTY_KEY, String.valueOf(2000));
        SentinelConfig.setConfig(MAX_ORIGIN_COUNT_PROPERTY_KEY, String.valueOf(1000));
        SentinelConfig.setConfig(STAT_SLIDING_WINDOW_INTERVAL_MS_PROP_KEY, String.valueOf(1000));
        SentinelConfig.setConfig(STAT_SLIDING_WINDOW_SAMPLE_COUNT_PROP_KEY, String.valueOf(2));
    }

    private static void loadProps() {
        Properties properties = SentinelConfigLoader.getProperties();
        for (Object key : properties.keySet()) {
            SentinelConfig.setConfig((String)key, (String)properties.get(key));
        }
    }

    public static String getConfig(String key) {
        AssertUtil.notNull(key, "key cannot be null");
        return props.get(key);
    }

    public static void setConfig(String key, String value) {
        AssertUtil.notNull(key, "key cannot be null");
        AssertUtil.notNull(value, "value cannot be null");
        props.put(key, value);
    }

    public static String removeConfig(String key) {
        AssertUtil.notNull(key, "key cannot be null");
        return props.remove(key);
    }

    public static void setConfigIfAbsent(String key, String value) {
        AssertUtil.notNull(key, "key cannot be null");
        AssertUtil.notNull(value, "value cannot be null");
        String v = props.get(key);
        if (v == null) {
            props.put(key, value);
        }
    }

    public static String getAppName() {
        return appName;
    }

    public static int getAppType() {
        return appType;
    }

    public static String charset() {
        return props.get(CHARSET);
    }

    public static long singleMetricFileSize() {
        try {
            return Long.parseLong(props.get(SINGLE_METRIC_FILE_SIZE));
        }
        catch (Throwable throwable) {
            RecordLog.warn("[SentinelConfig] Parse singleMetricFileSize fail, use default value: 52428800", throwable);
            return 0x3200000L;
        }
    }

    public static int totalMetricFileCount() {
        try {
            return Integer.parseInt(props.get(TOTAL_METRIC_FILE_COUNT));
        }
        catch (Throwable throwable) {
            RecordLog.warn("[SentinelConfig] Parse totalMetricFileCount fail, use default value: 6", throwable);
            return 6;
        }
    }

    public static int coldFactor() {
        try {
            int coldFactor = Integer.parseInt(props.get(COLD_FACTOR));
            if (coldFactor <= 1) {
                coldFactor = 3;
                RecordLog.warn("cold factor=" + coldFactor + ", should be larger than 1, use default value: " + 3, new Object[0]);
            }
            return coldFactor;
        }
        catch (Throwable throwable) {
            RecordLog.warn("[SentinelConfig] Parse coldFactor fail, use default value: 3", throwable);
            return 3;
        }
    }

    public static int statisticMaxRt() {
        return SentinelConfig.getIntOrSetDefault(STATISTIC_MAX_RT, 60000);
    }

    public static int maxResourceAmount() {
        return SentinelConfig.getIntOrSetDefault(MAX_RESOURCE_COUNT_PROPERTY_KEY, 6000);
    }

    public static int maxOriginAmount() {
        return SentinelConfig.getIntOrSetDefault(MAX_ORIGIN_COUNT_PROPERTY_KEY, 1000);
    }

    public static int maxEntranceContextAmount() {
        return SentinelConfig.getIntOrSetDefault(MAX_CONTEXT_COUNT_PROPERTY_KEY, 2000);
    }

    public static int metricLogFlushIntervalSec() {
        return SentinelConfig.getIntOrSetDefault(METRIC_LOG_FLUSH_INTERVAL_PROPERTY_KEY, 1);
    }

    public static int slidingWindowStatIntervalMs() {
        return SentinelConfig.getIntOrSetDefault(STAT_SLIDING_WINDOW_INTERVAL_MS_PROP_KEY, 1000);
    }

    public static int slidingWindowSampleCount() {
        return SentinelConfig.getIntOrSetDefault(STAT_SLIDING_WINDOW_SAMPLE_COUNT_PROP_KEY, 2);
    }

    private static int getIntOrSetDefault(String key, int defaultValue) {
        AssertUtil.assertNotBlank(key, "key cannot be blank");
        String v = props.get(key);
        try {
            if (StringUtil.isEmpty(v)) {
                return defaultValue;
            }
            return Integer.parseInt(v);
        }
        catch (Throwable throwable) {
            RecordLog.warn("[SentinelConfig] Invalid {} value: {}, using the default value instead: " + defaultValue, key, v, throwable);
            SentinelConfig.setConfig(key, String.valueOf(defaultValue));
            return defaultValue;
        }
    }

    private static int getPositiveIntOrSetDefault(String key, int defaultValue) {
        int v = SentinelConfig.getIntOrSetDefault(key, defaultValue);
        return v > 0 ? v : defaultValue;
    }

    private static void resolveAppName() {
        String separator;
        String n = System.getenv("mse.appName");
        if (!StringUtil.isBlank(n)) {
            appName = n;
            RecordLog.info("App name resolved from system env (mse.appName): " + appName, new Object[0]);
            return;
        }
        n = System.getProperty("mse.appName");
        if (!StringUtil.isBlank(n)) {
            appName = n;
            RecordLog.info("App name resolved from system property (mse.appName): " + appName, new Object[0]);
            return;
        }
        String envKey = SentinelConfig.toEnvKey(APP_NAME_PROP_KEY);
        n = System.getenv(envKey);
        if (!StringUtil.isBlank(n)) {
            appName = n;
            RecordLog.info("App name resolved from system env: " + appName, new Object[0]);
            return;
        }
        n = props.get(APP_NAME_PROP_KEY);
        if (!StringUtil.isBlank(n)) {
            appName = n;
            RecordLog.info("App name resolved from property csp.sentinel.app.name: " + appName, new Object[0]);
            return;
        }
        n = props.get(PROJECT_NAME_PROP_KEY);
        if (!StringUtil.isBlank(n)) {
            appName = n;
            RecordLog.info("App name resolved from property project.name: " + appName, new Object[0]);
            return;
        }
        String command = System.getProperty("sun.java.command");
        if (StringUtil.isBlank(command)) {
            RecordLog.warn("Cannot resolve default appName from property sun.java.command", new Object[0]);
            return;
        }
        if ((command = command.split("\\s")[0]).contains(separator = File.separator)) {
            String[] strs = "\\".equals(separator) ? command.split("\\\\") : command.split(separator);
            command = strs[strs.length - 1];
        }
        if (command.toLowerCase().endsWith(".jar")) {
            command = command.substring(0, command.length() - 4);
        }
        appName = command;
        RecordLog.info("App name resolved from default: ", appName);
    }

    private static String toEnvKey(String propKey) {
        return propKey.toUpperCase().replace('.', '_');
    }

    private SentinelConfig() {
    }

    static {
        try {
            SentinelConfig.initialize();
            SentinelConfig.loadProps();
            SentinelConfig.resolveAppName();
            SentinelConfig.resolveAppType();
            RecordLog.info("[SentinelConfig] Application type resolved: " + appType, new Object[0]);
        }
        catch (Throwable ex) {
            RecordLog.warn("[SentinelConfig] Failed to initialize", ex);
            ex.printStackTrace();
        }
    }
}

