/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.cluster.metrics;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.cluster.TokenResult;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.cluster.TokenResultStatus;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.cluster.metrics.ClusterMetric;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.config.SentinelConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.metric.MetricWriter;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.TimeUtil;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ClusterMetricManager {
    private static volatile ClusterMetricManager clusterMetricManager;
    private static final String TOKEN_FILE = "token_metrics.log";
    private static final int MEMORY_RECORD_QUEUE_SIZE = 10240;
    private static final long HALF_MINUTE_IN_MS = 30000L;
    private final ThreadLocal<SimpleDateFormat> commonDateFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private final MetricWriter metricWriter = new MetricWriter(SentinelConfig.singleMetricFileSize(), SentinelConfig.totalMetricFileCount());
    private final Set<String> toKeys = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final ExecutorService metricRecordTaskPool;
    private static final ScheduledExecutorService logTaskScheduler;
    private final Runnable writeTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long time = TimeUtil.currentTimeMillis() - 30000L;
                HashSet<String> innerKeys = new HashSet<String>();
                for (String toKey : ClusterMetricManager.this.toKeys) {
                    boolean shouldClear = true;
                    try {
                        String tokenStatistics = ClusterMetric.getInstance().getTokenStatisticsByKey(toKey);
                        if (tokenStatistics == null) continue;
                        int index = toKey.lastIndexOf("_");
                        String resource = toKey.substring(0, index);
                        long finalTime = Long.parseLong(toKey.substring(index + 1));
                        if (finalTime > time) {
                            shouldClear = false;
                            continue;
                        }
                        if ("NO_METRICS_CLEAR_ME".equals(tokenStatistics)) continue;
                        String dateStr = ((SimpleDateFormat)ClusterMetricManager.this.commonDateFormatThreadLocal.get()).format(new Date(finalTime));
                        ClusterMetricManager.this.metricWriter.commonWrite(Collections.singletonList(ClusterMetricManager.this.generateTokenStatLogLineStr(dateStr, resource, tokenStatistics)), ClusterMetricManager.TOKEN_FILE);
                    }
                    catch (Exception ex) {
                        RecordLog.warn("Failed to log ClusterTokenRequest metrics, key={}", toKey, ex);
                    }
                    finally {
                        if (!shouldClear) continue;
                        innerKeys.add(toKey);
                        ClusterMetric.getInstance().removeTokenStatisticsByKey(toKey);
                    }
                }
                ClusterMetricManager.this.toKeys.removeAll(innerKeys);
            }
            catch (Throwable e) {
                RecordLog.error("Failed to write ClusterTokenRequest metrics on disk", e);
            }
        }
    };

    private ClusterMetricManager() {
        logTaskScheduler.scheduleWithFixedDelay(this.writeTask, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterMetricManager getInstance() {
        if (clusterMetricManager != null) return clusterMetricManager;
        Class<ClusterMetricManager> clazz = ClusterMetricManager.class;
        synchronized (ClusterMetricManager.class) {
            if (clusterMetricManager != null) return clusterMetricManager;
            clusterMetricManager = new ClusterMetricManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return clusterMetricManager;
        }
    }

    public void tokenFlowRuleMetrics(FlowRule rule, TokenResult result, final int cost) {
        final String resource = rule.getResource();
        long time = TimeUtil.currentTimeMillis();
        time -= time % 1000L;
        final long finalTime = time;
        final int status = result.getStatus();
        final String type = TokenResultStatus.toStatisticString(status);
        metricRecordTaskPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ClusterMetric.getInstance().tokenStatusMetrics(resource, finalTime, type);
                    if (status == 0) {
                        ClusterMetric.getInstance().tokenTimeMetrics(resource, finalTime, cost);
                    }
                }
                catch (Throwable e) {
                    RecordLog.warn("ClusterTokenRequest metric record failed, {}, {}, {}, {}", resource, finalTime, type, cost, e);
                }
            }
        });
    }

    public String getTokenStatistics(String resource, long time) {
        long finalTime = time - time % 1000L;
        String clusterKey = ClusterMetric.generateMetricKey(resource, finalTime);
        String tokenStatistics = ClusterMetric.getInstance().getTokenStatisticsByKey(clusterKey);
        if (tokenStatistics == null) {
            return null;
        }
        this.toKeys.add(clusterKey);
        if ("NO_METRICS_CLEAR_ME".equals(tokenStatistics)) {
            return null;
        }
        return this.generateTokenStatLineStr(resource, finalTime, tokenStatistics);
    }

    private String generateTokenStatLineStr(String resource, long time, String tokenStatistics) {
        return resource + "!" + time + "!" + tokenStatistics;
    }

    private String generateTokenStatLogLineStr(String dateStr, String resource, String tokenStatistics) {
        return dateStr + "!" + resource + "!" + tokenStatistics;
    }

    static {
        metricRecordTaskPool = new ThreadPoolExecutor(1, 1, 300L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10240), new NamedThreadFactory("sentinel-cluster-metrics-record-task", true), new ThreadPoolExecutor.DiscardOldestPolicy());
        int coreNum = Runtime.getRuntime().availableProcessors();
        logTaskScheduler = new ScheduledThreadPoolExecutor(coreNum, new NamedThreadFactory("sentinel-cluster-metrics-log-task-scheduler", true), new ThreadPoolExecutor.DiscardOldestPolicy());
    }
}

