/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.cluster.metrics;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.CollectionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClusterMetric {
    public static final String NO_METRICS_AND_SHOULD_CLEAR = "NO_METRICS_CLEAR_ME";
    private static volatile ClusterMetric clusterMetric;
    private final Map<String, Map<String, Integer>> tokenResultStatusMetrics = new ConcurrentHashMap<String, Map<String, Integer>>();
    private final Map<String, Map<Integer, Integer>> tokenTimeMetrics = new ConcurrentHashMap<String, Map<Integer, Integer>>();

    private ClusterMetric() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterMetric getInstance() {
        if (clusterMetric != null) return clusterMetric;
        Class<ClusterMetric> clazz = ClusterMetric.class;
        synchronized (ClusterMetric.class) {
            if (clusterMetric != null) return clusterMetric;
            clusterMetric = new ClusterMetric();
            // ** MonitorExit[var0] (shouldn't be in output)
            return clusterMetric;
        }
    }

    public void tokenStatusMetrics(String ruleName, long time, String type) {
        Integer num;
        String toKey = ruleName + "_" + time;
        Map<String, Integer> timeStatistics = this.tokenResultStatusMetrics.get(toKey);
        if (timeStatistics == null) {
            timeStatistics = new ConcurrentHashMap<String, Integer>();
        }
        if ((num = timeStatistics.get(type)) == null) {
            num = 0;
        }
        num = num + 1;
        timeStatistics.put(type, num);
        this.tokenResultStatusMetrics.put(toKey, timeStatistics);
    }

    public void tokenTimeMetrics(String ruleName, long time, Integer cost) {
        Integer num;
        String toKey = ruleName + "_" + time;
        Map<Integer, Integer> timeStatistics = this.tokenTimeMetrics.get(toKey);
        if (timeStatistics == null) {
            timeStatistics = new ConcurrentHashMap<Integer, Integer>();
        }
        if ((num = timeStatistics.get(cost)) == null) {
            num = 0;
        }
        num = num + 1;
        timeStatistics.put(cost, num);
        this.tokenTimeMetrics.put(toKey, timeStatistics);
    }

    public Set<String> getKeys() {
        return this.tokenTimeMetrics.keySet();
    }

    public Map<Integer, Integer> getTokenTimeMetrics(String key) {
        HashMap res = this.tokenTimeMetrics.get(key);
        return res == null ? new HashMap() : res;
    }

    public Map<String, Integer> getTokenStatusMetrics(String key) {
        HashMap res = this.tokenResultStatusMetrics.get(key);
        return res == null ? new HashMap() : res;
    }

    String getTokenStatisticsByKey(String key) {
        if (key == null) {
            return null;
        }
        Map<String, Integer> types = this.tokenResultStatusMetrics.get(key);
        if (CollectionUtil.isEmpty(types)) {
            return null;
        }
        Map<Integer, Integer> times = this.tokenTimeMetrics.get(key);
        if (CollectionUtil.isEmpty(times)) {
            return NO_METRICS_AND_SHOULD_CLEAR;
        }
        StringBuilder builder = new StringBuilder();
        Set<Integer> timeKeys = times.keySet();
        for (Integer timeKey : timeKeys) {
            builder.append(timeKey).append(",").append(times.get(timeKey)).append('|');
        }
        builder.append('!');
        Set<String> typeKeys = types.keySet();
        for (String typeKey : typeKeys) {
            builder.append(typeKey).append(",").append(types.get(typeKey)).append('|');
        }
        return builder.toString();
    }

    public String getTokenStatisticsRawStr(String resource, long time) {
        String toKey = ClusterMetric.generateMetricKey(resource, time);
        return this.getTokenStatisticsByKey(toKey);
    }

    void removeTokenStatisticsByKey(String key) {
        try {
            this.tokenTimeMetrics.remove(key);
            this.tokenResultStatusMetrics.remove(key);
        }
        catch (Exception ex) {
            RecordLog.error("Failed to removeTokenStatisticsByKey, key={}", key);
        }
    }

    public void removeTokenStatistics(String resource, long time) {
        String toKey = ClusterMetric.generateMetricKey(resource, time);
        this.removeTokenStatisticsByKey(toKey);
    }

    static String generateMetricKey(String resource, long time) {
        return resource + "_" + time;
    }
}

