/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.cluster;

public final class TokenResultStatus {
    public static final int BAD_REQUEST = -4;
    public static final int INVALID_CREDENTIAL = -3;
    public static final int TOO_MANY_REQUEST = -2;
    public static final int FAIL = -1;
    public static final int FAIL_TIMEOUT = -102;
    public static final int TIMESTAMP_NOT_SATISFIED = -402;
    public static final int OK = 0;
    public static final int BLOCKED = 1;
    public static final int SHOULD_WAIT = 2;
    public static final int NO_RULE_EXISTS = 3;
    public static final int NO_REF_RULE_EXISTS = 4;
    public static final int NOT_AVAILABLE = 5;

    public static String toStatusString(int status) {
        switch (status) {
            case -1: {
                return "failed";
            }
            case -3: {
                return "authentication failed";
            }
            case -4: {
                return "bad request";
            }
            case -2: {
                return "quota exceeded";
            }
            case 0: {
                return "success";
            }
            case 3: {
                return "no rules in token server";
            }
        }
        return "unknown";
    }

    public static String toStatisticString(int status) {
        switch (status) {
            case -1: {
                return "FAIL";
            }
            case -3: {
                return "INVALID_CREDENTIAL";
            }
            case -4: {
                return "BAD_REQUEST";
            }
            case -2: {
                return "TOO_MANY_REQUEST";
            }
            case 0: 
            case 1: {
                return "OK";
            }
            case 3: {
                return "NO_RULE_EXISTS";
            }
            case 2: {
                return "SHOULD_WAIT";
            }
            case 4: {
                return "NO_REF_RULE_EXISTS";
            }
            case 5: {
                return "NOT_AVAILABLE";
            }
        }
        return "UNKNOWN";
    }

    private TokenResultStatus() {
    }
}

