/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.adaptive.config;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.adaptive.config.AdaptiveFlowSettingEntity;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SimplePropertyListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;

public class AdaptiveFlowSettingManager {
    public static final double DEFAULT_CPU_USAGE_TARGET = 0.6;
    private static boolean autoSystemAdaptiveEnabled = false;
    private static final AdaptiveFlowSettingPropertyListener LISTENER = new AdaptiveFlowSettingPropertyListener();
    private static SentinelProperty<AdaptiveFlowSettingEntity> currentProperty = new DynamicSentinelProperty<AdaptiveFlowSettingEntity>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<AdaptiveFlowSettingEntity> property) {
        AssertUtil.notNull(property, "property cannot be null");
        AdaptiveFlowSettingPropertyListener adaptiveFlowSettingPropertyListener = LISTENER;
        synchronized (adaptiveFlowSettingPropertyListener) {
            RecordLog.info("[AdaptiveFlowSettingManager] Registering new property to adaptive flow setting manager", new Object[0]);
            currentProperty.removeListener(LISTENER);
            property.addListener(LISTENER);
            currentProperty = property;
        }
    }

    public static boolean isAutoSystemAdaptiveEnabled() {
        return autoSystemAdaptiveEnabled;
    }

    public static boolean isValidProperties(AdaptiveFlowSettingEntity entity) {
        return entity != null && entity.getEnableAutoSystemAdaptive() != null;
    }

    private AdaptiveFlowSettingManager() {
    }

    static {
        currentProperty.addListener(LISTENER);
    }

    private static class AdaptiveFlowSettingPropertyListener
    extends SimplePropertyListener<AdaptiveFlowSettingEntity> {
        private AdaptiveFlowSettingPropertyListener() {
        }

        @Override
        public synchronized void configUpdate(AdaptiveFlowSettingEntity entity) {
            if (entity == null) {
                return;
            }
            if (!AdaptiveFlowSettingManager.isValidProperties(entity)) {
                RecordLog.warn("[AdaptiveFlowSettingManager] Ignoring invalid setting: " + entity, new Object[0]);
                return;
            }
            autoSystemAdaptiveEnabled = entity.getEnableAutoSystemAdaptive();
        }
    }
}

