/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.adaptive;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.adaptive.AdaptiveFlowLogger;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.adaptive.SystemAdaptiveThrottler;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.adaptive.config.AdaptiveFlowSettingManager;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.adaptive.pid.PIDController;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.metric.extension.SystemMetricExtension;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.TimeUtil;

public class PIDSystemMetricObserver
implements SystemMetricExtension {
    private static final long DEFAULT_SAMPLE_LOG_INTERVAL_MS = 200L;
    private static final double DEFAULT_P = 0.5;
    private static final double DEFAULT_I = 0.2;
    private static final double DEFAULT_D = 0.3;
    private static final double DEFAULT_SP = 0.6;
    private PIDController pidController = new PIDController(0.5, 0.2, 0.3, 0.6);
    private volatile long lastSampleTimestamp = 0L;

    @Override
    public void onCpuUsageCollected(double cpuUsage) {
        double cpuTarget = 0.6;
        if (!AdaptiveFlowSettingManager.isAutoSystemAdaptiveEnabled()) {
            cpuTarget = SystemRuleManager.getCpuUsageThreshold();
        }
        if (cpuTarget > 0.0) {
            double output = this.pidController.calcOutput(cpuUsage, cpuTarget);
            double p = this.convertCpuActionToProbability(cpuUsage, output);
            long curTime = TimeUtil.currentTimeMillis();
            if (p < 1.0 && curTime - this.lastSampleTimestamp >= 200L) {
                AdaptiveFlowLogger.info(String.format("[SAMPLE] cpu=%.3f, o=%.3f, p=%.2f", cpuUsage, output, p), new Object[0]);
                this.lastSampleTimestamp = curTime;
            }
            SystemAdaptiveThrottler.setPassProbability(p);
        }
    }

    private double convertCpuActionToProbability(double curCpu, double output) {
        if (output >= 0.0) {
            return 1.0;
        }
        double e = 1.0E-4;
        if (curCpu >= -e && curCpu <= e) {
            return 1.0;
        }
        double negativeFeedback = Math.max(-curCpu, Math.min(output, 0.0));
        return (curCpu + negativeFeedback) / curCpu;
    }

    @Override
    public void onSystemLoadCollected(double load) {
    }
}

