/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.ErrorEntryFreeException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.context.Context;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.ClusterNode;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.DefaultNode;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.Node;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.BlockException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.TimeUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.BiConsumer;
import java.util.Arrays;
import java.util.Map;

public abstract class Entry
implements AutoCloseable {
    private static final Object[] OBJECTS0 = new Object[0];
    private final long createTimestamp;
    private long completeTimestamp;
    private Node curNode;
    private Node originNode;
    private final int batchCount;
    private final Object[] args;
    private final Map<String, Object> argMap;
    private Throwable error;
    private BlockException blockError;
    protected final ResourceWrapper resourceWrapper;

    public Entry(ResourceWrapper resourceWrapper, int batchCount) {
        this(resourceWrapper, batchCount, null);
    }

    public Entry(ResourceWrapper resourceWrapper, int batchCount, Map<String, Object> argMap) {
        this(resourceWrapper, batchCount, null, argMap);
    }

    public Entry(ResourceWrapper resourceWrapper, int batchCount, Object[] args, Map<String, Object> argMap) {
        this.resourceWrapper = resourceWrapper;
        this.createTimestamp = TimeUtil.currentTimeMillis();
        this.batchCount = batchCount;
        this.args = args;
        this.argMap = argMap;
    }

    public ResourceWrapper getResourceWrapper() {
        return this.resourceWrapper;
    }

    public void exit() throws ErrorEntryFreeException {
        if (this.args == null || this.args.length == 0) {
            this.exit(this.batchCount, OBJECTS0);
        } else {
            this.exit(this.batchCount, this.args);
        }
    }

    public void exit(int count) throws ErrorEntryFreeException {
        if (this.args == null || this.args.length == 0) {
            this.exit(count, OBJECTS0);
        } else {
            this.exit(count, this.args);
        }
    }

    @Override
    public void close() {
        this.exit();
    }

    public abstract void exit(int var1, Object ... var2) throws ErrorEntryFreeException;

    protected abstract Entry trueExit(int var1, Object ... var2) throws ErrorEntryFreeException;

    public abstract Node getLastNode();

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public long getCompleteTimestamp() {
        return this.completeTimestamp;
    }

    public Entry setCompleteTimestamp(long completeTimestamp) {
        this.completeTimestamp = completeTimestamp;
        return this;
    }

    public Node getCurNode() {
        return this.curNode;
    }

    public ClusterNode getCurResourceNode() {
        if (this.curNode == null || !(this.curNode instanceof DefaultNode)) {
            return null;
        }
        return ((DefaultNode)this.curNode).getClusterNode();
    }

    public void setCurNode(Node node) {
        this.curNode = node;
    }

    public BlockException getBlockError() {
        return this.blockError;
    }

    public Entry setBlockError(BlockException blockError) {
        this.blockError = blockError;
        return this;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public Node getOriginNode() {
        return this.originNode;
    }

    public void setOriginNode(Node originNode) {
        this.originNode = originNode;
    }

    public abstract void whenTerminate(BiConsumer<Context, Entry> var1);

    public int getBatchCount() {
        return this.batchCount;
    }

    public Map<String, Object> getArgMap() {
        return this.argMap;
    }

    public String toString() {
        return "Entry{createTimestamp=" + this.createTimestamp + ", completeTimestamp=" + this.completeTimestamp + ", curNode=" + this.curNode + ", originNode=" + this.originNode + ", batchCount=" + this.batchCount + ", args=" + Arrays.toString(this.args) + ", argMap=" + this.argMap + ", error=" + this.error + ", blockError=" + this.blockError + ", resourceWrapper=" + this.resourceWrapper + '}';
    }
}

