/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.spring.bean;

import io.opentelemetry.javaagent.bootstrap.InstrumentationHolder;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.state.ArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Callback;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.ConfigKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.DataId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Endpoint;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.GroupId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Namespace;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

@Endpoint(value=ConfigEnum.ARMS_APP_CONFIG_ENDPOINT)
@DataId(value=ConfigEnum.ARMS_APP_CONFIG_DATA_ID)
@GroupId(value=ConfigEnum.ARMS_APP_CONFIG_GROUP_ID)
@Namespace(value=ConfigEnum.ARMS_APP_CONFIG_NAMESPACE)
public class TargetBeanClassCache
extends ArmsState {
    private static final PatchLogger logger = PatchLogger.getLogger(TargetBeanClassCache.class.getName());
    @ConfigKey(value="profiler.spring.beans.basePackage", type=String.class)
    private volatile String basePackageString = ConfigPropertiesUtil.getString("profiler.spring.beans.basePackage", "");
    @ConfigKey(value="profiler.spring.beans.enableLineNumber")
    private volatile boolean enableLineNumber = ConfigPropertiesUtil.getBoolean("profiler.spring.beans.enableLineNumber", false);
    private volatile Set<String> basePackageSet = new HashSet<String>();
    private final Set<String> instrumentedBeanClasses = Collections.synchronizedSet(new HashSet());
    public static TargetBeanClassCache INSTANCE = new TargetBeanClassCache();

    private TargetBeanClassCache() {
        super.registerConfigInstance(this);
    }

    @Override
    @Callback
    public void onConfigChange(String configInfo) {
        if (this.basePackageString == null) {
            return;
        }
        String[] basePackageArray = this.basePackageString.split(",");
        this.basePackageSet = new HashSet<String>();
        for (String basePackage : basePackageArray) {
            if (!StringUtils.isNotEmpty(basePackage)) continue;
            this.basePackageSet.add(basePackage.trim());
        }
    }

    public boolean isTargetBean(String beanName, Object beanInstance) {
        String className = beanInstance.getClass().getName();
        HashSet<String> annotations = new HashSet<String>();
        for (Annotation annotation : beanInstance.getClass().getAnnotations()) {
            annotations.add(annotation.annotationType().getName());
        }
        return this.isTargetBean(beanName, className, annotations);
    }

    public boolean isTargetBean(String beanName, String className, Set<String> annotations) {
        if (className.startsWith("org.springframework") || className.startsWith("java") || className.startsWith("sun")) {
            return false;
        }
        boolean meetAnnotationCondition = false;
        for (String annotation : annotations) {
            if (!annotation.equals("org.springframework.stereotype.Controller") && !annotation.equals("org.springframework.web.bind.annotation.RestController") && !annotation.equals("org.springframework.stereotype.Service") && !annotation.equals("org.springframework.stereotype.Repository") && !annotation.equals("org.springframework.stereotype.Component")) continue;
            meetAnnotationCondition = true;
            break;
        }
        boolean hasBasePackage = !this.basePackageSet.isEmpty();
        boolean meetPackageCondition = this.basePackageSet.isEmpty();
        for (String basePackage : this.basePackageSet) {
            if (!className.startsWith(basePackage)) continue;
            meetPackageCondition = true;
            break;
        }
        if (hasBasePackage) {
            return meetPackageCondition;
        }
        return meetAnnotationCondition;
    }

    public void addClass2InstrumentationTarget(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        String className = clazz.getName();
        if (this.instrumentedBeanClasses.contains(className)) {
            return;
        }
        this.addClass2InstrumentationTarget(clazz.getName());
    }

    public void addClass2InstrumentationTarget(String className) {
        this.instrumentedBeanClasses.add(className);
        try {
            if (InstrumentationHolder.getInstrumentation() != null) {
                Class[] classes;
                for (Class clazz : classes = InstrumentationHolder.getInstrumentation().getAllLoadedClasses()) {
                    if (!clazz.getName().equals(className)) continue;
                    InstrumentationHolder.getInstrumentation().retransformClasses(clazz);
                }
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, String.format("add %s to instrumentation target failed", className), t);
        }
    }

    public boolean isTargetBeanClass(String className) {
        return this.instrumentedBeanClasses.contains(className);
    }

    public void setBasePackageString(String basePackageString) {
        this.basePackageString = basePackageString;
    }

    public boolean isEnableLineNumber() {
        return this.enableLineNumber;
    }
}

