/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.mse;

import io.opentelemetry.javaagent.bootstrap.mse.MseStartupProfile;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class MseStartupReporter {
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "MseStartupReporter");
        thread.setDaemon(true);
        return thread;
    });
    private static String regionId = System.getenv("ARMS_REGION_ID");
    private static String mseHost;
    private static String mseAppId;
    private static String mseLicenseKey;
    private static String mseAppName;
    private static String mseNamespace;
    private static final String ip;
    private static boolean agentDebugEnabled;

    public static void reportSpringAnalysis(String content) {
        block3: {
            try {
                if (MseStartupReporter.isCloudProductMseEnable()) {
                    MseStartupReporter.doReport(MseStartupReporter.genMseSpringStartupAnalysisProfile(content, false));
                }
            }
            catch (Throwable e) {
                if (!agentDebugEnabled) break block3;
                System.err.println("[aliyun-java-agent][mse]reportAgentAdditionalInfo error:" + e.getMessage());
            }
        }
    }

    public static void reportSpringThrowable(Throwable t) {
        block3: {
            try {
                if (MseStartupReporter.isCloudProductMseEnable()) {
                    MseStartupReporter.doReport(MseStartupReporter.genMseSpringStartupThrowableProfile(MseStartupReporter.throwable2Content(t), false));
                }
            }
            catch (Throwable e) {
                if (!agentDebugEnabled) break block3;
                System.err.println("[aliyun-java-agent][mse]reportAgentAdditionalInfo error:" + e.getMessage());
            }
        }
    }

    public static void reportStartupError(Throwable t) {
        if (MseStartupReporter.isCloudProductMseEnable() && t != null) {
            MseStartupReporter.reportStartupError(MseStartupReporter.throwable2Content(t));
        }
    }

    public static void reportStartupError(String content) {
        block3: {
            try {
                if (MseStartupReporter.isCloudProductMseEnable() && !MseStartupReporter.isStringEmpty(content)) {
                    MseStartupReporter.doReport(MseStartupReporter.genMseAgentStartupProfile(content, false));
                }
            }
            catch (Throwable e) {
                if (!agentDebugEnabled) break block3;
                System.err.println("[aliyun-java-agent][mse]reportAgentAdditionalInfo error:" + e.getMessage());
            }
        }
    }

    public static void reportStartupSuccess(long startCostTimeInMs) {
        block3: {
            try {
                if (MseStartupReporter.isCloudProductMseEnable()) {
                    MseStartupReporter.doReport(MseStartupReporter.genMseAgentStartupProfile("startCostTimeInMs: " + startCostTimeInMs, true));
                }
            }
            catch (Throwable e) {
                if (!agentDebugEnabled) break block3;
                System.err.println("[aliyun-java-agent][mse]reportAgentAdditionalInfo error:" + e.getMessage());
            }
        }
    }

    private static String throwable2Content(Throwable e) {
        if (null == e) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\"Message\":\"").append(e.getMessage()).append("\",");
        sb.append("\"Cause\":\"").append(e.getCause()).append("\",");
        StringWriter writer = new StringWriter();
        if (e.getCause() != null) {
            e.getCause().printStackTrace(new PrintWriter(writer));
        }
        sb.append("\"StackTrace\":\"").append(writer).append("\"");
        sb.append("}");
        return sb.toString();
    }

    private static boolean isCloudProductMseEnable() {
        return mseLicenseKey != null && !mseLicenseKey.isEmpty();
    }

    private static String getIp() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress address = null;
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                String displayName = ni.getDisplayName();
                if (displayName != null && (displayName.startsWith("virbr") || displayName.equals("docker0"))) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    address = addresses.nextElement();
                    if (address.isLoopbackAddress() || address.getHostAddress().indexOf(":") != -1) continue;
                    return address.getHostAddress();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "unknown";
    }

    private static void doReport(MseStartupProfile agentStartupStatus) {
        block6: {
            boolean reportSuccessful;
            block5: {
                reportSuccessful = false;
                try {
                    MseStartupReporter.report0(agentStartupStatus, mseHost);
                    reportSuccessful = true;
                }
                catch (Throwable e) {
                    if (!agentDebugEnabled) break block5;
                    System.err.println("[aliyun-java-agent][mse]report0 error:" + e.getMessage());
                }
            }
            if (!reportSuccessful) {
                try {
                    mseHost = "mse." + regionId + ".aliyuncs.com";
                    MseStartupReporter.report0(agentStartupStatus, mseHost);
                }
                catch (Throwable e) {
                    if (!agentDebugEnabled) break block6;
                    System.err.println("[aliyun-java-agent][mse]report1 error:" + e.getMessage());
                }
            }
        }
    }

    private static MseStartupProfile genMseStartupProfile(String content, boolean success) {
        MseStartupProfile mseStartupProfile = new MseStartupProfile();
        mseStartupProfile.setCatalog("runtime");
        if (!MseStartupReporter.isStringEmpty(mseAppId)) {
            mseStartupProfile.addLabels("appId", mseAppId);
        }
        if (!MseStartupReporter.isStringEmpty(mseAppName)) {
            mseStartupProfile.addLabels("appName", mseAppName);
        }
        if (!MseStartupReporter.isStringEmpty(mseNamespace)) {
            mseStartupProfile.addLabels("namespace", mseNamespace);
        }
        mseStartupProfile.addLabels("ip", ip);
        mseStartupProfile.addLabels("agentVersion", "4.6.0");
        mseStartupProfile.addLabels("success", String.valueOf(success));
        if (!MseStartupReporter.isStringEmpty(mseLicenseKey)) {
            mseStartupProfile.setIdentity(mseLicenseKey);
        }
        if (!MseStartupReporter.isStringEmpty(mseAppId)) {
            mseStartupProfile.setIdentity(mseAppId);
        }
        mseStartupProfile.setReportTimestamp(String.valueOf(System.currentTimeMillis()));
        mseStartupProfile.setLicenseKey(mseLicenseKey);
        mseStartupProfile.setContent(content);
        mseStartupProfile.setIp(ip);
        return mseStartupProfile;
    }

    private static MseStartupProfile genMseSpringStartupAnalysisProfile(String content, boolean success) {
        MseStartupProfile mseStartupProfile = MseStartupReporter.genMseStartupProfile(content, success);
        mseStartupProfile.setType("spring-startup-analysis");
        return mseStartupProfile;
    }

    private static MseStartupProfile genMseSpringStartupThrowableProfile(String content, boolean success) {
        MseStartupProfile mseStartupProfile = MseStartupReporter.genMseStartupProfile(content, success);
        mseStartupProfile.setType("spring-startup-throwable");
        return mseStartupProfile;
    }

    private static MseStartupProfile genMseAgentStartupProfile(String content, boolean success) {
        MseStartupProfile mseStartupProfile = MseStartupReporter.genMseStartupProfile(content, success);
        mseStartupProfile.setType("agent-startup");
        return mseStartupProfile;
    }

    private static void report0(MseStartupProfile mseStartupProfile, String mseHost) throws IOException {
        Instant now = Instant.now();
        String datetime = DateTimeFormatter.ISO_INSTANT.format(now);
        StringBuilder urlString = new StringBuilder("http://" + mseHost + "/?");
        urlString.append(URLEncoder.encode("Action", "UTF-8")).append("=").append(URLEncoder.encode("ReportAppProfile", "UTF-8")).append("&");
        urlString.append(URLEncoder.encode("Version", "UTF-8")).append("=").append(URLEncoder.encode("2019-05-31", "UTF-8")).append("&");
        urlString.append(URLEncoder.encode("Timestamp", "UTF-8")).append("=").append(URLEncoder.encode(datetime, "UTF-8")).append("&");
        URL url = new URL(urlString.toString());
        HttpURLConnection con = MseStartupReporter.openConnection(url);
        con.setRequestMethod("POST");
        String mseDebugHost = System.getenv("MSE_DEBUG_HOST");
        if (mseDebugHost != null && !mseDebugHost.isEmpty()) {
            con.setRequestProperty("x-acs-debug-http-host", mseDebugHost);
        }
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        con.setRequestProperty("x-acs-action", "ReportAppProfile");
        con.setRequestProperty("x-mse-AppId", mseAppId);
        con.setRequestProperty("x-mse-Region", regionId);
        con.setConnectTimeout(100);
        con.setReadTimeout(500);
        con.setDoOutput(true);
        String jsonInputString = mseStartupProfile.toBody();
        try (OutputStream os = con.getOutputStream();){
            byte[] input = jsonInputString.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        int status = con.getResponseCode();
        String reqId = con.getHeaderField("x-acs-request-id");
        if (agentDebugEnabled) {
            System.err.println("[aliyun-java-agent][mse]MseStartupReporter report0 error," + status + ",reqId=" + reqId);
        }
    }

    static HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        return con;
    }

    private static boolean isStringEmpty(String s) {
        return s == null || s.isEmpty();
    }

    static {
        if (MseStartupReporter.isStringEmpty(regionId)) {
            regionId = System.getProperty("aliyun.javaagent.regionId");
        }
        if (MseStartupReporter.isStringEmpty(regionId)) {
            regionId = System.getProperty("mse.regionId");
        }
        if (MseStartupReporter.isStringEmpty(regionId)) {
            regionId = System.getProperty("oneagent.region");
        }
        if (MseStartupReporter.isStringEmpty(regionId)) {
            regionId = "cn-zhangjiakou";
        }
        mseHost = "mse-vpc." + regionId + ".aliyuncs.com";
        mseAppId = System.getProperty("mse.appId");
        mseLicenseKey = System.getProperty("mse.licenseKey");
        mseAppName = System.getProperty("mse.appName");
        mseNamespace = System.getProperty("mse.namespace");
        ip = MseStartupReporter.getIp();
        agentDebugEnabled = false;
        try {
            agentDebugEnabled = Boolean.parseBoolean(System.getProperty("otel.javaagent.debug"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

