/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class AliYunJavaAgentInit {
    public static boolean shouldIgnore() {
        try {
            if (AliYunJavaAgentInit.isForceAttachEnabled()) {
                return false;
            }
            if (AliYunJavaAgentInit.isJamComponent()) {
                return true;
            }
            if (AliYunJavaAgentInit.isArthasProcess()) {
                return true;
            }
            if (AliYunJavaAgentInit.isByteBuddyProcess()) {
                return true;
            }
            if (!AliYunJavaAgentInit.isJavaApplicationProcess()) {
                return true;
            }
            return AliYunJavaAgentInit.isSpecialJavaProcess();
        }
        catch (Throwable t) {
            System.out.println("Apsara Java Agent ignore check failed, e=" + t.getMessage());
            return false;
        }
    }

    private static boolean isForceAttachEnabled() {
        String forceAttach = System.getProperty("arms.attach.force");
        if ("true".equalsIgnoreCase(forceAttach)) {
            System.out.println("Apsara Java Agent force attach.");
            return true;
        }
        return false;
    }

    private static boolean isJamComponent() {
        String jamHome = System.getProperty("JAM_HOME");
        if ("/opt/jam".equals(jamHome)) {
            System.out.println("Detected JAM_HOME=/opt/jam, ignore Apsara Java Agent.");
            return true;
        }
        return false;
    }

    private static boolean isArthasProcess() {
        String[] cpItem;
        String cps = System.getProperty("java.class.path");
        if (cps != null && (cpItem = cps.split(File.pathSeparator)).length == 2 && (cpItem[0].endsWith("arthas-boot.jar") || cpItem[1].endsWith("arthas-boot.jar"))) {
            System.out.println("Apsara Java Agent rejected to bootstrap arthas-boot process");
            return true;
        }
        return false;
    }

    private static boolean isByteBuddyProcess() {
        String[] cpItem;
        String cps = System.getProperty("java.class.path");
        if (cps != null && (cpItem = cps.split(File.pathSeparator)).length == 1) {
            String[] parts = cpItem[0].split("/");
            Pattern pattern = Pattern.compile("byteBuddyAttacher.*\\.jar");
            if (parts.length >= 1 && pattern.matcher(parts[parts.length - 1]).matches()) {
                System.out.println("Apsara Java Agent rejected to bootstrap byteBuddyAttacher process");
                return true;
            }
        }
        return false;
    }

    private static boolean isJavaApplicationProcess() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.split("@")[0];
        try {
            Path execPath = Files.readSymbolicLink(Paths.get(String.format("/proc/%s/exe", pid), new String[0]));
            String execPathStr = execPath.toString();
            if (execPathStr.endsWith("java") || execPathStr.endsWith("javaw") || execPathStr.endsWith("openjdk")) {
                return true;
            }
            if (AliYunJavaAgentInit.isDynamicLinker(execPathStr)) {
                return AliYunJavaAgentInit.isJavaApplicationViaDynamicLinker(pid);
            }
            return AliYunJavaAgentInit.isJavaApplicationViaCommandLine(pid);
        }
        catch (Exception e) {
            System.out.println("Apsara Java Agent failed to detect process type: " + e.getMessage());
            return true;
        }
    }

    private static boolean isDynamicLinker(String execPath) {
        return execPath.contains("ld-linux") || execPath.contains("ld-musl") || execPath.endsWith("ld.so") || execPath.contains("ld-musl-x86_64") || execPath.contains("ld-linux-x86-64") || execPath.contains("ld-linux-aarch64") || execPath.contains("ld-linux-armhf");
    }

    private static boolean isShellScript(String execPath) {
        return execPath.endsWith("sh") || execPath.endsWith("bash") || execPath.endsWith("dash") || execPath.endsWith("zsh") || execPath.endsWith("tcsh") || execPath.endsWith("ksh");
    }

    private static boolean isJavaApplicationViaDynamicLinker(String pid) {
        try {
            String cmdline = AliYunJavaAgentInit.readCommandLine(pid);
            return AliYunJavaAgentInit.isJavaApplicationCommandLine(cmdline);
        }
        catch (Exception e) {
            System.out.println("Apsara Java Agent failed to check command line for dynamic linker: " + e.getMessage());
            return true;
        }
    }

    private static boolean isJavaApplicationViaCommandLine(String pid) {
        try {
            String cmdline = AliYunJavaAgentInit.readCommandLine(pid);
            return AliYunJavaAgentInit.isJavaApplicationCommandLine(cmdline);
        }
        catch (Exception e) {
            System.out.println("Apsara Java Agent failed to check command line: " + e.getMessage());
            return true;
        }
    }

    private static boolean isJavaApplicationCommandLine(String cmdline) {
        if (cmdline == null || cmdline.isEmpty()) {
            return false;
        }
        if (AliYunJavaAgentInit.isJvmToolCommandLine(cmdline)) {
            return false;
        }
        return cmdline.contains("java");
    }

    private static boolean isJvmToolCommandLine(String cmdline) {
        return cmdline.contains("jmap") || cmdline.contains("jstack") || cmdline.contains("jps") || cmdline.contains("jstat") || cmdline.contains("jinfo") || cmdline.contains("jhat") || cmdline.contains("jconsole") || cmdline.contains("visualvm") || cmdline.contains("jcmd");
    }

    private static boolean isSpecialJavaProcess() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.split("@")[0];
        try {
            String[] items;
            List<String> lines;
            File cmdlineFile = new File(String.format("/proc/%s/cmdline", pid));
            if (cmdlineFile.exists() && (lines = AliYunJavaAgentInit.readLines(cmdlineFile)).size() > 0 && (items = lines.get(0).split("\u0000")).length >= 2) {
                if (items[0].endsWith("java") && items[1].contains("-version")) {
                    System.out.println("Apsara Java Agent rejected to bootstrap java -version process");
                    return true;
                }
                if (items[0].endsWith("java") && items[items.length - 1].endsWith("CrashDataCollector")) {
                    System.out.println("Apsara Java Agent rejected to bootstrap CrashDataCollector process");
                    return true;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Apsara Java Agent failed to check special Java process: " + e.getMessage());
        }
        return false;
    }

    private static String readCommandLine(String pid) {
        try {
            List<String> lines;
            File cmdlineFile = new File(String.format("/proc/%s/cmdline", pid));
            if (cmdlineFile.exists() && (lines = AliYunJavaAgentInit.readLines(cmdlineFile)).size() > 0) {
                return lines.get(0);
            }
        }
        catch (Exception e) {
            System.out.println("Apsara Java Agent failed to read command line: " + e.getMessage());
        }
        return "";
    }

    public static boolean checkMemoryLimit() {
        long max = Runtime.getRuntime().maxMemory();
        long minimalMemoryRequired = 0x10000000L;
        String minimal = null;
        try {
            minimal = ConfigPropertiesUtil.getString("aliyun.java.agent.minimal.memory", "268435456");
            minimalMemoryRequired = Long.parseLong(minimal);
        }
        catch (Exception e) {
            System.out.println("Invalid aliyun.java.agent.minimal.memory value:" + minimal);
            return false;
        }
        if (max < minimalMemoryRequired) {
            System.out.println("Apsara Java Agent requires minimal memory of 256M, the current memory size is: " + max + ", Apsara Java Agent won't start. You can adjust it with -Daliyun.java.agent.minimal.memory=268435456");
            return false;
        }
        return true;
    }

    public static List<String> readLines(File file) throws IOException {
        BufferedReader reader = Files.newBufferedReader(file.toPath(), Charset.defaultCharset());
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }
}

